version 15 
set more off


*******************************
*** ALLBUS cumulation 82-12 ***
*******************************

use "c:\Daten\ZA4578_v1-0-0.dta", clear

recode V820 (99997=.) (99998=.) (99999=.) (0=.) (.f=.) (.d=.) (.k=.)

rename V820 hhinc

keep hhinc V4 V2 

rename V4 id

keep if V2 == 1982

drop V2 

save "c:\Daten\inc_82.dta", replace


************
*** 1982 ***
************

use "c:\Daten\ZA1160.dta", clear 

* AV 

egen miss = anycount (v62 v63 v64 v65 v66 v67), values(8,9)

recode v62-v67 (8=.) (9=.) 
recode v62 (4=1) (3=2) (2=3) (1=4), gen(v62_uk)
recode v66 (4=1) (3=2) (2=3) (1=4), gen(v66_uk)

factor v62-v67, mineigen(1) pcf
rotate, normalize // 1 Faktor, 44,4%

alpha v62_uk v63 v64 v65 v66_uk v67, item // Alpha = .74
alpha v63 v65 v67, item // Alpha = .73
alpha v62_uk v64 v66_uk, item // Alpha = .56

egen trad = rowmean (v62_uk v63 v64 v65 v66_uk v67) if miss < 3
egen sexism = rowmean (v63 v65 v67) if miss < 3
egen fwork = rowmean (v62_uk v64 v66_uk) if miss < 3


* UV 

gen west = 1 

gen foreign = 0

recode v369 (1=1) (2=0), gen(mann) 

gen age = v260 

gen gebjahr = 1982 - age
 
recode v68 (9=.)
recode v68 (1/2=1) (3/6=0), gen(evang) 
recode v68 (3=1) (1/2=0) (4/6=0), gen(kathol) 
recode v68 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode v68 (6=1) (1/5=0), gen(klos)

recode v69 (0=.) (9=.) 
gen kgang = 7-v69


gen yeduc = 9 if v158 == 1 | v158 == 2
replace yeduc = 10 if v158 == 3 
replace yeduc = 12 if v158 == 4 
replace yeduc = 13 if v158 == 5 
replace yeduc = yeduc + 2 if v159 == 5
replace yeduc = yeduc + 3 if v159 == 2 | v159 == 3 | v159 ==4 | v159 == 6
replace yeduc = yeduc + 4 if v159 == 7
replace yeduc = yeduc + 5 if v159 == 8
replace yeduc = . if v158 == 9 | v159 == 99

sum yeduc // 11.98

gen yeduc_ep = 9 if v251 == 1 | v251 == 2
replace yeduc_ep = 10 if v251 == 3 
replace yeduc_ep = 12 if v251 == 4 
replace yeduc_ep = 13 if v251 == 5 
replace yeduc_ep = yeduc_ep + 2 if v252 == 5
replace yeduc_ep = yeduc_ep + 3 if v252 == 2 | v252 == 3 | v252 ==4 | v252 == 6
replace yeduc_ep = yeduc_ep + 4 if v252 == 7
replace yeduc_ep = yeduc_ep + 5 if v252 == 8
replace yeduc_ep = . if v251 == 9 | v252 == 99
replace yeduc_ep = 11.98 if v251 == 0

recode v259 (8=.) (9=.) (0=.)
recode v259 (1=1) (2/6=0), gen(bv_kein)
recode v259 (1/5=0) (6=1), gen(bv_sonst) 
recode v259 (2=1) (1=0) (3/5=0), gen(bv_volks) 
recode v259 (3=1) (1/2=0) (4/5=0), gen(bv_mittlere) 
recode v259 (4=1) (1/3=0) (5=0), gen(bv_fachhoch) 
recode v259 (5=1) (1/4=0), gen(bv_abitur) 


recode v264 (0=.) (98/99=.)
recode v272 (0=.) (98/99=.)
recode v280 (0=.) (98/99=.)
recode v288 (0=.) (98/99=.)
recode v296 (0=.) (98/99=.)
recode v304 (0=.) (98/99=.)
recode v310 (0=.) (98/99=.)

gen k02_1 = 1 if (v262 == 3 | v262 == 4) & v264 < 3
gen k02_2 = 1 if (v270 == 3 | v270 == 4) & v272 < 3
gen k02_3 = 1 if (v278 == 3 | v278 == 4) & v280 < 3
gen k02_4 = 1 if (v286 == 3 | v286 == 4) & v288 < 3
gen k02_5 = 1 if (v294 == 3 | v294 == 4) & v296 < 3
gen k02_6 = 1 if (v302 == 3 | v302 == 4) & v304 < 3
gen k02_7 = 1 if (v308 == 3 | v308 == 4) & v310 < 3

gen k36_1 = 1 if (v262 == 3 | v262 == 4) & v264 > 2 & v264 < 7
gen k36_2 = 1 if (v270 == 3 | v270 == 4) & v272 > 2 & v272 < 7
gen k36_3 = 1 if (v278 == 3 | v278 == 4) & v280 > 2 & v280 < 7
gen k36_4 = 1 if (v286 == 3 | v286 == 4) & v288 > 2 & v288 < 7
gen k36_5 = 1 if (v294 == 3 | v294 == 4) & v296 > 2 & v296 < 7
gen k36_6 = 1 if (v302 == 3 | v302 == 4) & v304 > 2 & v304 < 7
gen k36_7 = 1 if (v308 == 3 | v308 == 4) & v310 > 2 & v310 < 7

gen k718_1 = 1 if (v262 == 3 | v262 == 4) & v264 > 6 & v264 < 19
gen k718_2 = 1 if (v270 == 3 | v270 == 4) & v272 > 6 & v272 < 19
gen k718_3 = 1 if (v278 == 3 | v278 == 4) & v280 > 6 & v280 < 19
gen k718_4 = 1 if (v286 == 3 | v286 == 4) & v288 > 6 & v288 < 19
gen k718_5 = 1 if (v294 == 3 | v294 == 4) & v296 > 6 & v296 < 19
gen k718_6 = 1 if (v302 == 3 | v302 == 4) & v304 > 6 & v304 < 19
gen k718_7 = 1 if (v308 == 3 | v308 == 4) & v310 > 6 & v310 < 19

gen kü18_1 = 1 if (v262 == 3 | v262 == 4) & v264 > 18 & v264 < .
gen kü18_2 = 1 if (v270 == 3 | v270 == 4) & v272 > 18 & v272 < .
gen kü18_3 = 1 if (v278 == 3 | v278 == 4) & v280 > 18 & v280 < .
gen kü18_4 = 1 if (v286 == 3 | v286 == 4) & v288 > 18 & v288 < .
gen kü18_5 = 1 if (v294 == 3 | v294 == 4) & v296 > 18 & v296 < .
gen kü18_6 = 1 if (v302 == 3 | v302 == 4) & v304 > 18 & v304 < .
gen kü18_7 = 1 if (v308 == 3 | v308 == 4) & v310 > 18 & v310 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & v204 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & v204 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & v204 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & v204 > 1


gen vz = 0 
replace vz = 1 if v160 == 1

gen tz = 0 
replace tz = 1 if v160 == 2

gen al = 0 
replace al = 1 if v160 == 3

gen nebenh = 0
replace nebenh = 1 if v160 == 4

gen ausb = 0 
replace ausb = 1 if v160 == 6 | v160 == 8

gen newp = 0 
replace newp = 1 if v160 ==  5 | v160 == 7 | v160 == 10 


gen vz_ep = 0 
replace vz_ep = 1 if v219 == 1

gen tz_ep = 0 
replace tz_ep = 1 if v219 == 2 

gen al_ep = 0 
replace al_ep = 1 if v219 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if v219 == 4 

gen ausb_ep = 0 
replace ausb_ep = 1 if v219 == 6 | v219 == 8 

gen newp_ep = 0 
replace newp_ep = 1 if v219 == 5 | v219 == 7 | v219 == 10

gen ep_miss = 0 
replace ep_miss = 1 if v219 == 0


recode v161 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0), gen(autonom)

replace autonom = 0 if v161 == 0 & v192 == 0 

recode v192 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = v192 if autonom == 0

sum autonom


recode v152 (8=.) (9=.)
gen w_lage = v152


gen hhgr = v318

gen year = 1982

gen pop_nd = 0

* Income 

rename v2 id

merge 1:1 id using "c:\Daten\inc_82.dta"

* Save

gen yeduc_p = .
gen vz_p = .
gen tz_p = .
gen al_p = .
gen nebenh_p = .
gen ausb_p = .
gen newp_p = .
gen p_miss = .
gen bm_kein = .
gen bm_sonst = .
gen bm_volks = .
gen bm_mittlere = .
gen bm_fachhoch = .
gen bm_abitur = .

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc ///
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhgr year pop_nd hhinc

save "c:\Daten\sex_role_1982.dta", replace


************
*** 1991 ***
************

use "c:\Daten\ZA1990_v2-0-0.dta", clear 

* AV 

egen miss = anycount (V42 V43 V44 V45 V46 V47), values(8,9)

recode V42-V47 (8=.) (9=.) 
recode V42 (4=1) (3=2) (2=3) (1=4), gen(V42_uk)
recode V46 (4=1) (3=2) (2=3) (1=4), gen(V46_uk)

factor V42-V47, mineigen(1) pcf
rotate, normalize // 1 Faktor, 46,7%

alpha V42_uk V43 V44 V45 V46_uk V47, item // Alpha = .77
alpha V43 V45 V47, item // Alpha = .71
alpha V42_uk V44 V46_uk, item // Alpha = .65

egen trad = rowmean (V42_uk V43 V44 V45 V46_uk V47) if miss < 3
replace trad = 5-trad 
egen sexism = rowmean (V43 V45 V47) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (V42_uk V44 V46_uk) if miss < 3
replace fwork = 5-fwork 


* UV 

recode V3 (1=1) (2=0), gen(west)

recode V323 (1=0) (2/30=1) (99=.), gen(foreign)

recode V139 (1=1) (2=0), gen(mann) 

gen age = V321
replace age = . if V321 == 999 

gen gebjahr = 1991 - age
 
recode V315 (9=.)
recode V315 (2/3=1) (4/6=0) (1=0), gen(evang) 
recode V315 (1=1) (2/6=0), gen(kathol) 
recode V315 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode V315 (6=1) (1/5=0), gen(klos)

recode V316 (9=.) 
gen kgang = 7-V316


gen yeduc = 9 if V140 == 1 | V140 == 2
replace yeduc = 10 if V140 == 3 
replace yeduc = 12 if V140 == 4 
replace yeduc = 13 if V140 == 5
replace yeduc = 12 if V140 == 7 | V140 == 6 
egen ausbild = anycount(V142 V143 V144 V145 V147 V148 V149), values(1)
replace yeduc = yeduc + 2 if V146 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 3 if V152 == 1
replace yeduc = yeduc + 4 if V150 == 1
replace yeduc = yeduc + 5 if V151 == 1
replace yeduc = . if V140 == 9 | V144 == 9
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 12.99

gen yeduc_ep = 9 if V216 == 1 | V216 == 2
replace yeduc_ep = 10 if V216 == 3 
replace yeduc_ep = 12 if V216 == 4 
replace yeduc_ep = 13 if V216 == 5
replace yeduc_ep = 12 if V216 == 6
egen ausbild_ep = anycount(V217 V218 V219 V220 V222 V223 V224), values(1)
replace yeduc_ep = yeduc_ep + 2 if V221 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 3 if V227 == 1
replace yeduc_ep = yeduc_ep + 4 if V225 == 1
replace yeduc_ep = yeduc_ep + 5 if V226 == 1
replace yeduc_ep = . if V216 == 9 | V218 == 9
replace yeduc_ep = 12.99 if V216 == 0
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if (V275 == 1 | V275 == 2)
replace yeduc_p = 10 if V275 == 3
replace yeduc_p = 12 if V275 == 4
replace yeduc_p = 13 if V275 == 5
replace yeduc_p = 12 if V275 == 6
egen ausbild_p = anycount(V276 V277 V278 V279 V281 V282 V283), values(1)
replace yeduc_p = yeduc_p + 2 if V280 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 3 if V286 == 1
replace yeduc_p = yeduc_p + 4 if V284 == 1
replace yeduc_p = yeduc_p + 5 if V285 == 1
replace yeduc_p = 18 if yeduc_p > 18 & yeduc_p < .

recode V313 (8=.) (9=.) (0=.) (7=.)
recode V313 (1=1) (2/6=0), gen(bv_kein)
recode V313 (1/5=0) (6=1), gen(bv_sonst)  
recode V313 (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode V313 (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode V313 (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode V313 (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode V314 (8=.) (9=.)
recode V314 (1=1) (2/6=0), gen(bm_kein)
recode V314 (1/5=0) (6=1), gen(bm_sonst)  
recode V314 (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode V314 (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode V314 (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode V314 (5=1) (1/4=0) (6=0), gen(bm_abitur)


recode V344 (996=.) (999=.)
recode V350 (996=.) (999=.)
recode V356 (996=.) (999=.)
recode V362 (996=.) (999=.)
recode V368 (996=.) (999=.)
recode V374 (996=.) (999=.)
recode V380 (996=.) (999=.)

gen k02_1 = 1 if (V341 == 3 | V341 == 4) & V344 < 3
gen k02_2 = 1 if (V347 == 3 | V347 == 4) & V350 < 3
gen k02_3 = 1 if (V353 == 3 | V353 == 4) & V356 < 3
gen k02_4 = 1 if (V359 == 3 | V359 == 4) & V362 < 3
gen k02_5 = 1 if (V365 == 3 | V365 == 4) & V368 < 3
gen k02_6 = 1 if (V371 == 3 | V371 == 4) & V374 < 3
gen k02_7 = 1 if (V377 == 3 | V377 == 4) & V380 < 3

gen k36_1 = 1 if (V341 == 3 | V341 == 4) & V344 > 2 & V344 < 7
gen k36_2 = 1 if (V347 == 3 | V347 == 4) & V350 > 2 & V350 < 7
gen k36_3 = 1 if (V353 == 3 | V353 == 4) & V356 > 3 & V356 < 7
gen k36_4 = 1 if (V359 == 3 | V359 == 4) & V362 > 2 & V362 < 7
gen k36_5 = 1 if (V365 == 3 | V365 == 4) & V368 > 2 & V368 < 7
gen k36_6 = 1 if (V371 == 3 | V371 == 4) & V374 > 2 & V374 < 7
gen k36_7 = 1 if (V377 == 3 | V377 == 4) & V380 > 2 & V374 < 7

gen k718_1 = 1 if (V341 == 3 | V341 == 4) & V344 > 6 & V344 < 19
gen k718_2 = 1 if (V347 == 3 | V347 == 4) & V350 > 6 & V350 < 19
gen k718_3 = 1 if (V353 == 3 | V353 == 4) & V356 > 6 & V356 < 19
gen k718_4 = 1 if (V359 == 3 | V359 == 4) & V362 > 6 & V362 < 19
gen k718_5 = 1 if (V365 == 3 | V365 == 4) & V368 > 6 & V368 < 19
gen k718_6 = 1 if (V371 == 3 | V371 == 4) & V374 > 6 & V374 < 19
gen k718_7 = 1 if (V377 == 3 | V377 == 4) & V380 > 6 & V374 < 19

gen kü18_1 = 1 if (V341 == 3 | V341 == 4) & V344 > 18 & V344 < .
gen kü18_2 = 1 if (V347 == 3 | V347 == 4) & V350 > 18 & V350 < .
gen kü18_3 = 1 if (V353 == 3 | V353 == 4) & V356 > 18 & V356 < .
gen kü18_4 = 1 if (V359 == 3 | V359 == 4) & V362 > 18 & V362 < .
gen kü18_5 = 1 if (V365 == 3 | V365 == 4) & V368 > 18 & V368 < .
gen kü18_6 = 1 if (V371 == 3 | V371 == 4) & V374 > 18 & V374 < .
gen kü18_7 = 1 if (V377 == 3 | V377 == 4) & V380 > 18 & V380 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & V200 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & V200 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & V200 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & V200 > 1


gen vz = 0 
replace vz = 1 if V154 == 1

gen tz = 0 
replace tz = 1 if V154 == 2 | V154 == 3

gen al = 0 
replace al = 1 if V177 == 3

gen nebenh = 0
replace nebenh = 1 if V154 == 4

gen ausb = 0 
replace ausb = 1 if V177 == 1 | V177 == 5

gen newp = 0 
replace newp = 1 if V177 == 2 | V177 == 4 | V177 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if V229 == 1

gen tz_ep = 0 
replace tz_ep = 1 if V229 == 2 | V229 == 3 

gen al_ep = 0 
replace al_ep = 1 if V237 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if V229 == 4 

gen ausb_ep = 0 
replace ausb_ep = 1 if V237 == 1 | V237 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if V237 == 2 | V237 == 4 | V237 == 6

gen ep_miss = 0 
replace ep_miss = 1 if V229 == 0


gen vz_p = vz_ep
replace vz_p = 1 if V288 == 1

gen tz_p = tz_ep
replace tz_p = 1 if V288 == 2 | V288 == 3

gen al_p = al_ep 
replace al_p = 1 if V296 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if V288 == 4 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if V296 == 1 | V296 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if V296 == 2 | V296 == 4 | V296 == 6

gen p_miss = 1 
replace p_miss = 0 if (V229 > 0 & V299 < 9) | (V288 > 0 & V288 < 9) 


recode V156 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (14=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0) (99=.), gen(autonom)

replace autonom = 0 if V156 == 0 & V181 == 0 

recode V181 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (14=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = V181 if autonom == 0

sum autonom


recode V131 (8=.) (9=.)
gen w_lage = V131 


recode V338 (99997=.) (99998=.) (99999=.) (0=.) (.f=.) (.d=.) (.k=.)

rename V338 hhinc 

replace hhinc = 250 if V339 == 1 
replace hhinc = 500 if V339 == 2 
replace hhinc = 700 if V339 == 3 
replace hhinc = 900 if V339 == 4  
replace hhinc = 1125 if V339 == 5  
replace hhinc = 1375 if V339 == 6  
replace hhinc = 1625 if V339 == 7  
replace hhinc = 1875 if V339 == 8  
replace hhinc = 2125 if V339 == 9  
replace hhinc = 2375 if V339 == 10  
replace hhinc = 2625 if V339 == 11  
replace hhinc = 2875 if V339 == 12  
replace hhinc = 3250 if V339 == 13
replace hhinc = 3750 if V339 == 14 
replace hhinc = 4250 if V339 == 15 
replace hhinc = 4750 if V339 == 16 
replace hhinc = 5250 if V339 == 17 
replace hhinc = 5750 if V339 == 18 
replace hhinc = 7000 if V339 == 19 
replace hhinc = 9000 if V339 == 20 
replace hhinc = 12500 if V339 == 21 
replace hhinc = 17500 if V339 == 22 

replace hhinc = hhinc / 2   
 
 
gen hhgr = V340

gen year = 1991

gen pop_nd = 0

* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc ///
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd

save "c:\Daten\sex_role_1991.dta", replace


************
*** 1992 ***
************

use "c:\Daten\ZA2140_v2-0-0.dta", clear 

* AV 

egen miss = anycount (V14 V15 V16 V17 V18 V19), values(8,9)

recode V14-V19 (8=.) (9=.) 
recode V14 (4=1) (3=2) (2=3) (1=4), gen(V14_uk)
recode V18 (4=1) (3=2) (2=3) (1=4), gen(V18_uk)

factor V14-V18, mineigen(1) pcf
rotate, normalize // 1 Faktor, 49,8%

alpha V14_uk V15 V16 V17 V18_uk V19, item // Alpha = .78
alpha V15 V17 V19, item // Alpha = .72
alpha V14_uk V16 V18_uk, item // Alpha = .66

egen trad = rowmean (V14_uk V15 V16 V17 V18_uk V19) if miss < 3
replace trad = 5-trad
egen sexism = rowmean (V15 V17 V19) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (V14_uk V16 V18_uk) if miss < 3
replace fwork = 5-fwork


* UV 

recode V3 (1=1) (2=0), gen(west)

recode V319 (1=0) (2/30=1) (99=.), gen(foreign) 

recode V146 (1=1) (2=0), gen(mann) 

gen age = V317
replace age = . if V317 == 999 

gen gebjahr = 1992 - age
 
recode V303 (9=.)
recode V303 (2/3=1) (4/6=0) (1=0), gen(evang) 
recode V303(1=1) (2/6=0), gen(kathol) 
recode V303 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode V303 (6=1) (1/5=0), gen(klos)

recode V306 (9=.) 
gen kgang = 7-V306


gen yeduc = 9 if V147 == 1 | V147 == 2
replace yeduc = 10 if V147 == 3 
replace yeduc = 12 if V147 == 4 
replace yeduc = 13 if V147 == 5
replace yeduc = 12 if V147 == 7 | V147 == 6 
egen ausbild = anycount(V150 V151 V152 V153 V155 V156 V157), values(1)
replace yeduc = yeduc + 2 if V154 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 3 if V152 == 1
replace yeduc = yeduc + 4 if V150 == 1
replace yeduc = yeduc + 5 if V151 == 1
replace yeduc = . if V140 == 9 | V144 == 9
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 13.34

gen yeduc_ep = 9 if V204 == 1 | V204 == 2
replace yeduc_ep = 10 if V204 == 3 
replace yeduc_ep = 12 if V204 == 4 
replace yeduc_ep = 13 if V204 == 5
replace yeduc_ep = 12 if V204 == 6 | V204 == 7
egen ausbild_ep = anycount(V205 V206 V207 V208 V210 V211 V212), values(1)
replace yeduc_ep = yeduc_ep + 2 if V209 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 3 if V215 == 1
replace yeduc_ep = yeduc_ep + 4 if V213 == 1
replace yeduc_ep = yeduc_ep + 5 if V214 == 1
replace yeduc_ep = . if V204 == 9 | V205 == 9
replace yeduc_ep = 13.34 if V204 == 0
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if (V258 == 1 | V258 == 2)
replace yeduc_p = 10 if V258 == 3
replace yeduc_p = 12 if V258 == 4
replace yeduc_p = 13 if V258 == 5
replace yeduc_p = 12 if V258 == 6 | V258 == 7
egen ausbild_p = anycount(V259 V260 V261 V262 V264 V265 V266), values(1)
replace yeduc_p = yeduc_p + 2 if V263 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 3 if V269 == 1
replace yeduc_p = yeduc_p + 4 if V267 == 1
replace yeduc_p = yeduc_p + 5 if V268 == 1
replace yeduc_p = 18 if yeduc_p > 18 & yeduc_p < .

recode V301 (8=.) (9=.) (0=.)
recode V301 (1=1) (2/6=0), gen(bv_kein)
recode V301 (1/5=0) (6=1), gen(bv_sonst) 
recode V301 (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode V301 (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode V301 (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode V301 (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode V314 (8=.) (9=.)
recode V314 (1=1) (2/6=0), gen(bm_kein)
recode V314 (1/5=0) (6=1), gen(bm_sonst) 
recode V314 (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode V314 (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode V314 (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode V314 (5=1) (1/4=0) (6=0), gen(bm_abitur)


recode V344 (996=.) (999=.)
recode V351 (996=.) (999=.)
recode V358 (996=.) (999=.)
recode V365 (996=.) (999=.)
recode V372 (996=.) (999=.)
recode V379 (996=.) (999=.)
recode V386 (996=.) (999=.)

gen k02_1 = 1 if (V340 == 3 | V340== 4) & V344 < 3
gen k02_2 = 1 if (V347 == 3 | V347 == 4) & V351 < 3
gen k02_3 = 1 if (V354 == 3 | V354 == 4) & V358 < 3
gen k02_4 = 1 if (V361 == 3 | V361 == 4) & V365 < 3
gen k02_5 = 1 if (V368 == 3 | V368 == 4) & V372 < 3
gen k02_6 = 1 if (V375 == 3 | V375 == 4) & V379 < 3
gen k02_7 = 1 if (V382 == 3 | V382 == 4) & V386 < 3

gen k36_1 = 1 if (V340 == 3 | V340 == 4) & V344 > 2 & V344 < 7
gen k36_2 = 1 if (V347 == 3 | V347 == 4) & V351 > 2 & V351 < 7
gen k36_3 = 1 if (V354 == 3 | V354 == 4) & V358 > 3 & V358 < 7
gen k36_4 = 1 if (V361 == 3 | V361 == 4) & V365 > 2 & V365 < 7
gen k36_5 = 1 if (V368 == 3 | V368 == 4) & V372 > 2 & V372 < 7
gen k36_6 = 1 if (V375 == 3 | V375 == 4) & V379 > 2 & V379 < 7
gen k36_7 = 1 if (V382 == 3 | V382 == 4) & V386 > 2 & V386 < 7

gen k718_1 = 1 if (V340 == 3 | V340 == 4) & V344 > 6 & V344 < 19
gen k718_2 = 1 if (V347 == 3 | V347 == 4) & V351 > 6 & V351 < 19
gen k718_3 = 1 if (V354 == 3 | V354 == 4) & V358 > 6 & V358 < 19
gen k718_4 = 1 if (V361 == 3 | V361 == 4) & V365 > 6 & V365 < 19
gen k718_5 = 1 if (V368 == 3 | V368 == 4) & V372 > 6 & V372 < 19
gen k718_6 = 1 if (V375 == 3 | V375 == 4) & V379 > 6 & V379 < 19
gen k718_7 = 1 if (V382 == 3 | V382 == 4) & V386 > 6 & V386 < 19

gen kü18_1 = 1 if (V340 == 3 | V340 == 4) & V344 > 18 & V344 < .
gen kü18_2 = 1 if (V347 == 3 | V347 == 4) & V351 > 18 & V351 < .
gen kü18_3 = 1 if (V354 == 3 | V354 == 4) & V358 > 18 & V358 < .
gen kü18_4 = 1 if (V361 == 3 | V361 == 4) & V365 > 18 & V365 < .
gen kü18_5 = 1 if (V368 == 3 | V368 == 4) & V372 > 18 & V372 < .
gen kü18_6 = 1 if (V375 == 3 | V375 == 4) & V379 > 18 & V379 < .
gen kü18_7 = 1 if (V382 == 3 | V382 == 4) & V386 > 18 & V386 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & V198 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & V198 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & V198 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & V198 > 1


gen vz = 0 
replace vz = 1 if V162 == 1

gen tz = 0 
replace tz = 1 if V162 == 2 | V162 == 3

gen al = 0 
replace al = 1 if V183 == 3

gen nebenh = 0
replace nebenh = 1 if V162 == 4

gen ausb = 0 
replace ausb = 1 if V183 == 1 | V183 == 5

gen newp = 0 
replace newp = 1 if V183 == 2 | V183 == 4 | V183 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if V217 == 1

gen tz_ep = 0 
replace tz_ep = 1 if V217 == 2 | V217 == 3 

gen al_ep = 0 
replace al_ep = 1 if V226 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if V217 == 4 

gen ausb_ep = 0 
replace ausb_ep = 1 if V226 == 1 | V226 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if V226 == 2 | V226 == 4 | V226 == 6

gen ep_miss = 0 
replace ep_miss = 1 if V217 == 0


gen vz_p = vz_ep
replace vz_p = 1 if V271 == 1

gen tz_p = tz_ep
replace tz_p = 1 if V271 == 2 | V271 == 3

gen al_p = al_ep 
replace al_p = 1 if V280 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if V271 == 4 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if V280 == 1 | V280 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if V280 == 2 | V280 == 4 | V280 == 6

gen p_miss = 1 
replace p_miss = 0 if (V226 > 0 & V226 < 9) | (V271 > 0 & V271 < 9) 


recode V164 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0) (99=.), gen(autonom)

replace autonom = 0 if V164 == 0 & V187 == 0 

recode V187 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = V187 if autonom == 0

sum autonom


recode V83 (8=.) (9=.)
gen w_lage = V83


recode V337 (99997=.) (99998=.) (99999=.) (0=.) (.f=.) (.d=.) (.k=.)

rename V337 hhinc 

replace hhinc = 250 if V338 == 1 
replace hhinc = 500 if V338 == 2 
replace hhinc = 700 if V338 == 3 
replace hhinc = 900 if V338 == 4  
replace hhinc = 1125 if V338 == 5  
replace hhinc = 1375 if V338 == 6  
replace hhinc = 1625 if V338 == 7  
replace hhinc = 1875 if V338 == 8  
replace hhinc = 2125 if V338 == 9  
replace hhinc = 2375 if V338 == 10  
replace hhinc = 2625 if V338 == 11  
replace hhinc = 2875 if V338 == 12  
replace hhinc = 3250 if V338 == 13
replace hhinc = 3750 if V338 == 14 
replace hhinc = 4250 if V338 == 15 
replace hhinc = 4750 if V338 == 16 
replace hhinc = 5250 if V338 == 17 
replace hhinc = 5750 if V338 == 18 
replace hhinc = 7000 if V338 == 19 
replace hhinc = 9000 if V338 == 20 
replace hhinc = 12500 if V338 == 21 
replace hhinc = 17500 if V338 == 22 

replace hhinc = hhinc / 2   
 
 
gen hhgr = V339

gen year = 1992

gen pop_nd = 1

* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc /// 
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd 

save "c:\Daten\sex_role_1992.dta", replace


************
*** 1996 ***
************

use "c:\Daten\ZA2800_v2-0-0.dta", clear 

* AV 

egen miss = anycount (V7 V8 V9 V10 V11 V12), values(8,9)

recode V7-V12 (8=.) (9=.) 
recode V7 (4=1) (3=2) (2=3) (1=4), gen(V7_uk)
recode V11 (4=1) (3=2) (2=3) (1=4), gen(V11_uk)

factor V7-V12, mineigen(1) pcf
rotate, normalize // 2 Faktoren, 46,6% und 17,6%

alpha V7_uk V8 V9 V10 V11_uk V12, item // Alpha = .77
alpha V8 V10 V12, item // Alpha = .74
alpha V9 V7_uk V11_uk, item // Alpha = .66

egen trad = rowmean (V7_uk V8 V9 V10 V11_uk V12) if miss < 3
replace trad = 5-trad
egen sexism = rowmean (V8 V10 V12) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (V9 V7_uk V11_uk) if miss < 3
replace fwork = 5-fwork


* UV 

recode V3 (1=1) (2=0), gen(west)

recode V4 (3=1) (0/2=0) (9=.), gen(foreign)

recode V141 (1=1) (2=0), gen(mann) 

gen age = V37
replace age = . if V37 == 999 

gen gebjahr = 1996 - age
 
recode V318 (9=.)
recode V318 (2/3=1) (4/6=0) (1=0), gen(evang) 
recode V318(1=1) (2/6=0), gen(kathol) 
recode V318 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode V318 (6=1) (1/5=0), gen(klos)

recode V319 (9=.) 
gen kgang = 7-V319


gen yeduc = 9 if V142 == 1 | V142 == 2
replace yeduc = 10 if V142 == 3 
replace yeduc = 12 if V142 == 4 
replace yeduc = 13 if V142 == 5
replace yeduc = 12 if V142 == 7 | V147 == 6 
egen ausbild = anycount(V143 V144 V145 V146 V148 V149 V150), values(1)
replace yeduc = yeduc + 2 if V147 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 3 if V153 == 1
replace yeduc = yeduc + 4 if V151 == 1
replace yeduc = yeduc + 5 if V152 == 1
replace yeduc = . if V142 == 9 | V143 == 9
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 12.95

gen yeduc_ep = 9 if V190 == 1 | V190 == 2
replace yeduc_ep = 10 if V204 == 3 
replace yeduc_ep = 12 if V204 == 4 
replace yeduc_ep = 13 if V204 == 5
replace yeduc_ep = 12 if V204 == 6 | V204 == 7
egen ausbild_ep = anycount(V191 V192 V193 V194 V196 V197 V198), values(1)
replace yeduc_ep = yeduc_ep + 2 if V195 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 3 if V201 == 1
replace yeduc_ep = yeduc_ep + 4 if V199 == 1
replace yeduc_ep = yeduc_ep + 5 if V200 == 1
replace yeduc_ep = . if V190 == 9 | V191 == 9
replace yeduc_ep = 12.95 if V190 == 0
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if V224 == 1 | V224 == 2
replace yeduc_p = 10 if V224 == 3
replace yeduc_p = 12 if V224 == 4
replace yeduc_p = 13 if V224 == 5
replace yeduc_p = 12 if V224 == 6 | V224 == 7
egen ausbild_p = anycount(V225 V226 V227 V228 V230 V231 V232), values(1)
replace yeduc_p = yeduc_p + 2 if V229 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 3 if V235 == 1
replace yeduc_p = yeduc_p + 4 if V233 == 1
replace yeduc_p = yeduc_p + 5 if V234 == 1
replace yeduc_p = 18 if yeduc_p > 18 & yeduc_p < .


recode V259 (8=.) (9=.) (0=.)
recode V259 (1=1) (2/6=0), gen(bv_kein)
recode V259 (1/5=0) (6=1), gen(bv_sonst) 
recode V259 (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode V259 (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode V259 (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode V259 (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode V260 (8=.) (9=.)
recode V260 (1=1) (2/6=0), gen(bm_kein)
recode V260 (1/5=0) (6=1), gen(bm_sonst) 
recode V260 (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode V260 (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode V260 (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode V260 (5=1) (1/4=0) (6=0), gen(bm_abitur)


recode V268 (996=.) (999=.)
recode V275 (996=.) (999=.)
recode V282 (996=.) (999=.)
recode V289 (996=.) (999=.)
recode V296 (996=.) (999=.)
recode V303 (996=.) (999=.)
recode V310 (996=.) (999=.)

gen k02_1 = 1 if (V264 == 3 | V264== 4) & V268 < 3
gen k02_2 = 1 if (V271 == 3 | V271 == 4) & V275 < 3
gen k02_3 = 1 if (V278 == 3 | V278 == 4) & V282 < 3
gen k02_4 = 1 if (V285 == 3 | V285 == 4) & V289 < 3
gen k02_5 = 1 if (V292 == 3 | V292 == 4) & V296 < 3
gen k02_6 = 1 if (V299 == 3 | V299 == 4) & V303 < 3
gen k02_7 = 1 if (V306 == 3 | V306 == 4) & V310 < 3

gen k36_1 = 1 if (V264 == 3 | V264 == 4) & V268 > 2 & V268 < 7
gen k36_2 = 1 if (V271 == 3 | V271 == 4) & V275 > 2 & V275 < 7
gen k36_3 = 1 if (V278 == 3 | V278 == 4) & V282 > 3 & V282 < 7
gen k36_4 = 1 if (V285 == 3 | V285 == 4) & V289 > 2 & V289 < 7
gen k36_5 = 1 if (V292 == 3 | V292 == 4) & V296 > 2 & V296 < 7
gen k36_6 = 1 if (V299 == 3 | V299 == 4) & V303 > 2 & V303 < 7
gen k36_7 = 1 if (V306 == 3 | V306 == 4) & V310 > 2 & V310 < 7

gen k718_1 = 1 if (V264 == 3 | V264 == 4) & V268 > 6 & V268 < 19
gen k718_2 = 1 if (V271 == 3 | V271 == 4) & V275 > 6 & V275 < 19
gen k718_3 = 1 if (V278 == 3 | V278 == 4) & V282 > 6 & V282 < 19
gen k718_4 = 1 if (V285 == 3 | V285 == 4) & V289 > 6 & V289 < 19
gen k718_5 = 1 if (V292 == 3 | V292 == 4) & V296 > 6 & V296 < 19
gen k718_6 = 1 if (V299 == 3 | V299 == 4) & V303 > 6 & V303 < 19
gen k718_7 = 1 if (V306 == 3 | V306 == 4) & V310 > 6 & V310 < 19

gen kü18_1 = 1 if (V264 == 3 | V264 == 4) & V268 > 18 & V268 < .
gen kü18_2 = 1 if (V271 == 3 | V271 == 4) & V275 > 18 & V275 < .
gen kü18_3 = 1 if (V278 == 3 | V278 == 4) & V282 > 18 & V282 < .
gen kü18_4 = 1 if (V285 == 3 | V285 == 4) & V289 > 18 & V289 < .
gen kü18_5 = 1 if (V292 == 3 | V292 == 4) & V296 > 18 & V296 < .
gen kü18_6 = 1 if (V299 == 3 | V299 == 4) & V303 > 18 & V303 < .
gen kü18_7 = 1 if (V306 == 3 | V306 == 4) & V310 > 18 & V310 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & V183 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & V183 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & V183 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & V183 > 1


gen vz = 0 
replace vz = 1 if V155 == 1

gen tz = 0 
replace tz = 1 if V155 == 2

gen al = 0 
replace al = 1 if V170 == 3

gen nebenh = 0
replace nebenh = 1 if V155 == 3

gen ausb = 0 
replace ausb = 1 if V170 == 1 | V170 == 5

gen newp = 0 
replace newp = 1 if V170 == 2 | V170 == 4 | V170 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if V203 == 1

gen tz_ep = 0 
replace tz_ep = 1 if V203 == 2  

gen al_ep = 0 
replace al_ep = 1 if V211 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if V203 == 3 

gen ausb_ep = 0 
replace ausb_ep = 1 if V211 == 1 | V211 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if V211 == 2 | V211 == 4 | V211 == 6

gen ep_miss = 0 
replace ep_miss = 1 if V203 == 0


gen vz_p = vz_ep
replace vz_p = 1 if V237 == 1

gen tz_p = tz_ep
replace tz_p = 1 if V237 == 2

gen al_p = al_ep 
replace al_p = 1 if V245 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if V237 == 3 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if V245 == 1 | V245 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if V245 == 2 | V245 == 4 | V245 == 6

gen p_miss = 1 
replace p_miss = 0 if (V203 > 0 & V203 < 9) | (V237 > 0 & V237 < 9) 


recode V156 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0) (99=.), gen(autonom)

replace autonom = 0 if V156 == 0 & V172 == 0 

recode V172 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = V172 if autonom == 0

sum autonom


recode V114 (8=.) (9=.)
gen w_lage = V114


recode V261 (99997=.) (99998=.) (99999=.) (0=.)

rename V261 inc 

replace inc = 250 if V262 == 1 
replace inc = 500 if V262 == 2 
replace inc = 700 if V262 == 3 
replace inc = 900 if V262 == 4  
replace inc = 1125 if V262 == 5  
replace inc = 1375 if V262 == 6  
replace inc = 1625 if V262 == 7  
replace inc = 1875 if V262 == 8  
replace inc = 2125 if V262 == 9  
replace inc = 2375 if V262 == 10  
replace inc = 2625 if V262 == 11  
replace inc = 2875 if V262 == 12  
replace inc = 3250 if V262 == 13
replace inc = 3750 if V262 == 14 
replace inc = 4250 if V262 == 15 
replace inc = 4750 if V262 == 16 
replace inc = 5250 if V262 == 17 
replace inc = 5750 if V262 == 18 
replace inc = 7000 if V262 == 19 
replace inc = 9000 if V262 == 20 
replace inc = 12500 if V262 == 21 

recode V314 (99997=.) (99998=.) (99999=.) (.f=.) (.d=.) (.k=.)

rename V314 hhinc 

replace hhinc = inc if hhinc == 99996

replace hhinc = 250 if V315 == 1 
replace hhinc = 500 if V315 == 2 
replace hhinc = 700 if V315 == 3 
replace hhinc = 900 if V315 == 4  
replace hhinc = 1125 if V315 == 5  
replace hhinc = 1375 if V315 == 6  
replace hhinc = 1625 if V315 == 7  
replace hhinc = 1875 if V315 == 8  
replace hhinc = 2125 if V315 == 9  
replace hhinc = 2375 if V315 == 10  
replace hhinc = 2625 if V315 == 11  
replace hhinc = 2875 if V315 == 12  
replace hhinc = 3250 if V315 == 13
replace hhinc = 3750 if V315 == 14 
replace hhinc = 4250 if V315 == 15 
replace hhinc = 4750 if V315 == 16 
replace hhinc = 5250 if V315 == 17 
replace hhinc = 5750 if V315 == 18 
replace hhinc = 7000 if V315 == 19 
replace hhinc = 9000 if V315 == 20 
replace hhinc = 12500 if V315 == 21 
replace hhinc = 17500 if V315 == 22 

replace hhinc = hhinc / 2   

 
gen hhgr = V263

gen year = 1996

gen pop_nd = 1

* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc ///
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd 

save "c:\Daten\sex_role_1996.dta", replace


************
*** 2000 ***
************

use "c:\Daten\ZA3450_v2-0-0.dta", clear 

* AV 

egen miss = anycount (v10 v11 v12 v13 v14 v15), values(8,9)

recode v10-v15 (8=.) (9=.) 
recode v10 (4=1) (3=2) (2=3) (1=4), gen(v10_uk)
recode v14 (4=1) (3=2) (2=3) (1=4), gen(v14_uk)

factor v10-v15, mineigen(1) pcf
rotate, normalize // 1 Faktor, 48,4%

alpha v10_uk v11 v12 v13 v14_uk v15, item // Alpha = .78
alpha v11 v13 v15, item // Alpha = .75
alpha v10_uk v12 v14_uk, item // Alpha = .67

egen trad = rowmean (v10_uk v11 v12 v13 v14_uk v15) if miss < 3
replace trad = 5-trad
egen sexism = rowmean (v11 v13 v15) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (v10_uk v12 v14_uk) if miss < 3
replace fwork = 5-fwork


* UV 

recode v3 (1=1) (2=0), gen(west)

recode v4 (3=1) (1/2=0) (4=0) (9=.), gen(foreign)

recode v216 (1=1) (2=0), gen(mann) 

gen age = v219

gen gebjahr = 2000 - age
 
recode v619 (9=.)
recode v619 (2/3=1) (4/6=0) (1=0), gen(evang) 
recode v619(1=1) (2/6=0), gen(kathol) 
recode v619 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode v619 (6=1) (1/5=0), gen(klos)

recode v622 (9=.) 
gen kgang = 7-v622


gen yeduc = 9 if v221 == 1 | v221 == 2
replace yeduc = 10 if v221 == 3 
replace yeduc = 12 if v221 == 4 
replace yeduc = 13 if v221 == 5
replace yeduc = 12 if v221 == 7 | v221 == 6 
egen ausbild = anycount(v222 v223 v224 v225 v227 v228 v229), values(1)
replace yeduc = yeduc + 2 if v226 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 3 if v232 == 1
replace yeduc = yeduc + 4 if v230 == 1
replace yeduc = yeduc + 5 if v231 == 1
replace yeduc = . if v221 == 9 | v222 == 9
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 13.01

gen yeduc_ep = 9 if v331 == 1 | v331 == 2
replace yeduc_ep = 10 if v331 == 3 
replace yeduc_ep = 12 if v331 == 4 
replace yeduc_ep = 13 if v331 == 5
replace yeduc_ep = 12 if v331 == 6 | v331 == 7
egen ausbild_ep = anycount(v332 v333 v334 v335 v337 v338 v339), values(1)
replace yeduc_ep = yeduc_ep + 2 if v336 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 3 if v342 == 1
replace yeduc_ep = yeduc_ep + 4 if v340 == 1
replace yeduc_ep = yeduc_ep + 5 if v341 == 1
replace yeduc_ep = . if v331 == 9 | v332 == 9
replace yeduc_ep = 13.01 if v331 == 0
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if v408 == 1 | v408 == 2
replace yeduc_p = 10 if v408 == 3
replace yeduc_p = 12 if v408 == 4
replace yeduc_p = 13 if v408 == 5
replace yeduc_p = 12 if v408 == 6 | v408 == 7
egen ausbild_p = anycount(v409 v410 v411 v412 v414 v415 v416), values(1)
replace yeduc_p = yeduc_p + 2 if v413 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 3 if v419 == 1
replace yeduc_p = yeduc_p + 4 if v417 == 1
replace yeduc_p = yeduc_p + 5 if v418 == 1


recode v458 (8=.) (9=.) (0=.)
recode v458 (1=1) (2/6=0), gen(bv_kein)
recode v458 (1/5=0) (6=1), gen(bv_sonst) 
recode v458 (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode v458 (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode v458 (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode v458 (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode v459 (8=.) (9=.)
recode v459 (1=1) (2/6=0), gen(bm_kein)
recode v459 (1/5=0) (6=1), gen(bm_sonst) 
recode v459 (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode v459 (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode v459 (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode v459 (5=1) (1/4=0) (6=0), gen(bm_abitur)


recode v493 (996=.) (999=.)
recode v500 (996=.) (999=.)
recode v507 (996=.) (999=.)
recode v514 (996=.) (999=.)
recode v521 (996=.) (999=.)
recode v528 (996=.) (999=.)
recode v535 (996=.) (999=.)

gen k02_1 = 1 if (v489 == 3 | v489 == 4) & v493 < 3
gen k02_2 = 1 if (v496 == 3 | v496 == 4) & v500 < 3
gen k02_3 = 1 if (v503 == 3 | v503 == 4) & v507 < 3
gen k02_4 = 1 if (v510 == 3 | v510 == 4) & v514 < 3
gen k02_5 = 1 if (v517 == 3 | v517 == 4) & v521 < 3
gen k02_6 = 1 if (v524 == 3 | v524 == 4) & v528 < 3
gen k02_7 = 1 if (v531 == 3 | v531 == 4) & v535 < 3

gen k36_1 = 1 if (v489 == 3 | v489 == 4) & v493 > 2 & v493 < 7
gen k36_2 = 1 if (v496 == 3 | v496 == 4) & v500 > 2 & v500 < 7
gen k36_3 = 1 if (v503 == 3 | v503 == 4) & v507 > 3 & v507 < 7
gen k36_4 = 1 if (v510 == 3 | v510 == 4) & v514 > 2 & v514 < 7
gen k36_5 = 1 if (v517 == 3 | v517 == 4) & v521 > 2 & v521 < 7
gen k36_6 = 1 if (v524 == 3 | v524 == 4) & v528 > 2 & v528 < 7
gen k36_7 = 1 if (v531 == 3 | v531 == 4) & v535 > 2 & v535 < 7

gen k718_1 = 1 if (v489 == 3 | v489 == 4) & v493 > 6 & v493 < 19
gen k718_2 = 1 if (v496 == 3 | v496 == 4) & v500 > 6 & v500 < 19
gen k718_3 = 1 if (v503 == 3 | v503 == 4) & v507 > 6 & v507 < 19
gen k718_4 = 1 if (v510 == 3 | v510 == 4) & v514 > 6 & v514 < 19
gen k718_5 = 1 if (v517 == 3 | v517 == 4) & v521 > 6 & v521 < 19
gen k718_6 = 1 if (v524 == 3 | v524 == 4) & v528 > 6 & v528 < 19
gen k718_7 = 1 if (v531 == 3 | v531 == 4) & v535 > 6 & v535 < 19

gen kü18_1 = 1 if (v489 == 3 | v489 == 4) & v493 > 18 & v493 < .
gen kü18_2 = 1 if (v496 == 3 | v496 == 4) & v500 > 18 & v500 < .
gen kü18_3 = 1 if (v503 == 3 | v503 == 4) & v507 > 18 & v507 < .
gen kü18_4 = 1 if (v510 == 3 | v510 == 4) & v514 > 18 & v514 < .
gen kü18_5 = 1 if (v517 == 3 | v517 == 4) & v521 > 18 & v521 < .
gen kü18_6 = 1 if (v524 == 3 | v524 == 4) & v528 > 18 & v528 < .
gen kü18_7 = 1 if (v531 == 3 | v531 == 4) & v535 > 18 & v535 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & v285 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & v285 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & v285 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & v285 > 1


gen vz = 0 
replace vz = 1 if v234 == 1

gen tz = 0 
replace tz = 1 if v234 == 2

gen al = 0 
replace al = 1 if v234 == 3

gen nebenh = 0
replace nebenh = 1 if v234 == 3

gen ausb = 0 
replace ausb = 1 if v256 == 1 | v256 == 5

gen newp = 0 
replace newp = 1 if v256 == 2 | v256 == 4 | v256 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if v344 == 1

gen tz_ep = 0 
replace tz_ep = 1 if v344 == 2  

gen al_ep = 0 
replace al_ep = 1 if v360 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if v344 == 3 

gen ausb_ep = 0 
replace ausb_ep = 1 if v360 == 1 | v360 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if v360 == 2 | v360 == 4 | v360 == 6

gen ep_miss = 0 
replace ep_miss = 1 if v344 == 0


gen vz_p = vz_ep
replace vz_p = 1 if v421 == 1

gen tz_p = tz_ep
replace tz_p = 1 if v421 == 2

gen al_p = al_ep 
replace al_p = 1 if v437 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if v421 == 3 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if v437 == 1 | v437 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if v437 == 2 | v437 == 4 | v437 == 6

gen p_miss = 1 
replace p_miss = 0 if (v344 > 0 & v344 < 9) | (v421 > 0 & v421 < 9) 


recode v235 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0) (99=.), gen(autonom)

replace autonom = 0 if v235 == 0 & v269 == 0 

recode v269 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = v269 if autonom == 0


recode v213 (8=.) (9=.)
gen w_lage = v213


recode v484 (99997=.) (99998=.) (99999=.) (0=.)

rename v484 inc 

replace inc = 0 if v485 == 0 
replace inc = 250 if v485 == 1 
replace inc = 500 if v485 == 2 
replace inc = 700 if v485 == 3 
replace inc = 900 if v485 == 4  
replace inc = 1125 if v485 == 5  
replace inc = 1375 if v485 == 6  
replace inc = 1625 if v485 == 7  
replace inc = 1875 if v485 == 8  
replace inc = 2125 if v485 == 9  
replace inc = 2375 if v485 == 10  
replace inc = 2625 if v485 == 11  
replace inc = 2875 if v485 == 12  
replace inc = 3250 if v485 == 13
replace inc = 3750 if v485 == 14 
replace inc = 4250 if v485 == 15 
replace inc = 4750 if v485 == 16 
replace inc = 5250 if v485 == 17 
replace inc = 5750 if v485 == 18 
replace inc = 7000 if v485 == 19 
replace inc = 9000 if v485 == 20 
replace inc = 12500 if v485 == 21 

recode v540 (99997=.) (99998=.) (99999=.) (.f=.) (.d=.) (.k=.)

rename v540 hhinc 

replace hhinc = inc if hhinc == 99996

replace hhinc = 250 if v541 == 1 
replace hhinc = 500 if v541 == 2 
replace hhinc = 700 if v541 == 3 
replace hhinc = 900 if v541 == 4  
replace hhinc = 1125 if v541 == 5  
replace hhinc = 1375 if v541 == 6  
replace hhinc = 1625 if v541 == 7  
replace hhinc = 1875 if v541 == 8  
replace hhinc = 2125 if v541 == 9  
replace hhinc = 2375 if v541 == 10  
replace hhinc = 2625 if v541 == 11  
replace hhinc = 2875 if v541 == 12  
replace hhinc = 3250 if v541 == 13
replace hhinc = 3750 if v541 == 14 
replace hhinc = 4250 if v541 == 15 
replace hhinc = 4750 if v541 == 16 
replace hhinc = 5250 if v541 == 17 
replace hhinc = 5750 if v541 == 18 
replace hhinc = 7000 if v541 == 19 
replace hhinc = 9000 if v541 == 20 
replace hhinc = 12500 if v541 == 21 
replace hhinc = 17500 if v541 == 22 

replace hhinc = hhinc / 2 

 
recode v488 (99=.) 
gen hhgr = v488

gen year = 2000

gen pop_nd = 1

* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc /// 
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd 

save "c:\Daten\sex_role_2000.dta", replace


************
*** 2004 ***
************

use "c:\Daten\ZA3762_v2-0-0.dta", clear 

* AV 

egen miss = anycount (v172 v173 v174 v175 v176 v177), values(8,9)

recode v172-v177 (8=.) (9=.) 
recode v172 (4=1) (3=2) (2=3) (1=4), gen(v172_uk)
recode v176 (4=1) (3=2) (2=3) (1=4), gen(v176_uk)

factor v172-v177, mineigen(1) pcf
rotate, normalize // 1 Faktor, 52,4%

alpha v172_uk v173 v174 v175 v176_uk v177, item // Alpha = .82
alpha v173 v175 v177, item // Alpha = .77
alpha v172_uk v174 v176_uk, item // Alpha = .72

egen trad = rowmean (v172_uk v173 v174 v175 v176_uk v177) if miss < 3
replace trad = 5-trad
egen sexism = rowmean (v173 v175 v177) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (v172_uk v174 v176_uk) if miss < 3
replace fwork = 5-fwork


* UV 

recode v3 (1=1) (2=0), gen(west)

recode v4 (3=1) (1/2=0) (4=0) (9=.), gen(foreign)

recode v55 (1=1) (2=0), gen(mann) 

recode v58 (999=.)
gen age = v58

gen gebjahr = 2004 - age
 
recode v667 (9=.) (7=.)
recode v667 (1/2=1) (3/6=0), gen(evang) 
recode v667 (3=1) (1/2=0) (4/6=0), gen(kathol) 
recode v667 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode v667 (6=1) (1/5=0), gen(klos)

recode v669 (9=.) 
gen kgang = 7-v669


gen yeduc = 9 if v60 == 1 | v60 == 2
replace yeduc = 10 if v60 == 3 
replace yeduc = 12 if v60 == 4 
replace yeduc = 13 if v60 == 5
replace yeduc = 12 if v60 == 7 | v60 == 6 
egen ausbild = anycount(v61 v62 v63 v64 v66 v67 v68), values(1)
replace yeduc = yeduc + 2 if v65 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 3 if v71 == 1
replace yeduc = yeduc + 4 if v69 == 1
replace yeduc = yeduc + 5 if v70 == 1
replace yeduc = . if v60 == 9 | v61 == 9
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 12.98

gen yeduc_ep = 9 if v342 == 1 | v342 == 2
replace yeduc_ep = 10 if v342 == 3 
replace yeduc_ep = 12 if v342 == 4 
replace yeduc_ep = 13 if v342 == 5
replace yeduc_ep = 12 if v342 == 6 | v331 == 7
egen ausbild_ep = anycount(v343 v344 v345 v346 v348 v349 v350), values(1)
replace yeduc_ep = yeduc_ep + 2 if v347 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 3 if v353 == 1
replace yeduc_ep = yeduc_ep + 4 if v351 == 1
replace yeduc_ep = yeduc_ep + 5 if v352 == 1
replace yeduc_ep = . if v342 == 9 | v343 == 9
replace yeduc_ep = 12.98 if v342 == 0
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if v375 == 1 | v375 == 2
replace yeduc_p = 10 if v375 == 3
replace yeduc_p = 12 if v375 == 4
replace yeduc_p = 13 if v375 == 5
replace yeduc_p = 12 if v375 == 6 | v342 == 7
egen ausbild_p = anycount(v376 v377 v378 v379 v381 v382 v383), values(1)
replace yeduc_p = yeduc_p + 2 if v380 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 3 if v386 == 1
replace yeduc_p = yeduc_p + 4 if v384 == 1
replace yeduc_p = yeduc_p + 5 if v385 == 1
replace yeduc_p = 18 if yeduc_p > 18 & yeduc_p < .


recode v427 (98=.) (99=.) (0=.)
recode v427 (1=1) (2/6=0), gen(bv_kein)
recode v427 (1/5=0) (6=1), gen(bv_sonst) 
recode v427 (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode v427 (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode v427 (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode v427 (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode v428 (98=.) (99=.)
recode v428 (1=1) (2/6=0), gen(bm_kein)
recode v428 (1/5=0) (6=1), gen(bm_sonst) 
recode v428 (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode v428 (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode v428 (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode v428 (5=1) (1/4=0) (6=0), gen(bm_abitur)


recode v487 (996=.) (999=.)
recode v497 (996=.) (999=.)
recode v507 (996=.) (999=.)
recode v517 (996=.) (999=.)
recode v527 (996=.) (999=.)
recode v537 (996=.) (999=.)
recode v547 (996=.) (999=.)

gen k02_1 = 1 if (v483 == 3 | v483 == 4) & v487 < 3
gen k02_2 = 1 if (v493 == 3 | v493 == 4) & v497 < 3
gen k02_3 = 1 if (v503 == 3 | v503 == 4) & v507 < 3
gen k02_4 = 1 if (v513 == 3 | v513 == 4) & v517 < 3
gen k02_5 = 1 if (v523 == 3 | v523 == 4) & v527 < 3
gen k02_6 = 1 if (v533 == 3 | v533 == 4) & v537 < 3
gen k02_7 = 1 if (v543 == 3 | v543 == 4) & v547 < 3

gen k36_1 = 1 if (v483 == 3 | v483 == 4) & v487 > 2 & v487 < 7
gen k36_2 = 1 if (v493 == 3 | v493 == 4) & v497 > 2 & v497 < 7
gen k36_3 = 1 if (v503 == 3 | v503 == 4) & v507 > 3 & v507 < 7
gen k36_4 = 1 if (v513 == 3 | v513 == 4) & v517 > 2 & v517 < 7
gen k36_5 = 1 if (v523 == 3 | v523 == 4) & v527 > 2 & v527 < 7
gen k36_6 = 1 if (v533 == 3 | v533 == 4) & v537 > 2 & v537 < 7
gen k36_7 = 1 if (v543 == 3 | v543 == 4) & v547 > 2 & v547 < 7

gen k718_1 = 1 if (v483 == 3 | v483 == 4) & v487 > 6 & v487 < 19
gen k718_2 = 1 if (v493 == 3 | v493 == 4) & v497 > 6 & v497 < 19
gen k718_3 = 1 if (v503 == 3 | v503 == 4) & v507 > 6 & v507 < 19
gen k718_4 = 1 if (v513 == 3 | v513 == 4) & v517 > 6 & v517 < 19
gen k718_5 = 1 if (v523 == 3 | v523 == 4) & v527 > 6 & v527 < 19
gen k718_6 = 1 if (v533 == 3 | v533 == 4) & v537 > 6 & v537 < 19
gen k718_7 = 1 if (v543 == 3 | v543 == 4) & v547 > 6 & v547 < 19

gen kü18_1 = 1 if (v483 == 3 | v483 == 4) & v487 > 18 & v487 < .
gen kü18_2 = 1 if (v493 == 3 | v493 == 4) & v497 > 18 & v497 < .
gen kü18_3 = 1 if (v503 == 3 | v503 == 4) & v507 > 18 & v507 < .
gen kü18_4 = 1 if (v513 == 3 | v513 == 4) & v517 > 18 & v517 < .
gen kü18_5 = 1 if (v523 == 3 | v523 == 4) & v527 > 18 & v527 < .
gen kü18_6 = 1 if (v533 == 3 | v533 == 4) & v537 > 18 & v537 < .
gen kü18_7 = 1 if (v543 == 3 | v543 == 4) & v547 > 18 & v547 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & v337 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & v337 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & v337 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & v337 > 1


gen vz = 0 
replace vz = 1 if v73 == 1

gen tz = 0 
replace tz = 1 if v73 == 2

gen al = 0 
replace al = 1 if v104 == 3

gen nebenh = 0
replace nebenh = 1 if v73 == 3

gen ausb = 0 
replace ausb = 1 if v104 == 1 | v104 == 5

gen newp = 0 
replace newp = 1 if v104 == 2 | v104 == 4 | v104 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if v355 == 1

gen tz_ep = 0 
replace tz_ep = 1 if v355 == 2  

gen al_ep = 0 
replace al_ep = 1 if v368 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if v355 == 3 

gen ausb_ep = 0 
replace ausb_ep = 1 if v368 == 1 | v368 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if v368 == 2 | v368 == 4 | v368 == 6

gen ep_miss = 0 
replace ep_miss = 1 if v355 == 0


gen vz_p = vz_ep
replace vz_p = 1 if v388 == 1

gen tz_p = tz_ep
replace tz_p = 1 if v388 == 2

gen al_p = al_ep 
replace al_p = 1 if v401 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if v388 == 3 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if v401 == 1 | v401 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if v401 == 2 | v401 == 4 | v401 == 6

gen p_miss = 1 
replace p_miss = 0 if (v355 > 0 & v355 < 9) | (v388 > 0 & v388 < 9) 


recode v75 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0) (99=.), gen(autonom)

replace autonom = 0 if v75 == 0 & v108 == 0 

recode v108 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = v108 if autonom == 0


recode v6 (8=.) (9=.)
gen w_lage = v6


recode v557 (99997=.) (99998=.) (99999=.) (0=.) (.f=.) (.d=.) (.k=.)
rename v557 hhinc


recode v481 (99=.) 
gen hhgr = v481

gen year = 2004

gen pop_nd = 1

* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc ///
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom /// 
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd 

save "c:\Daten\sex_role_2004.dta", replace


************
*** 2008 ***
************

use "c:\Daten\ZA4600_v2-1-0.dta", clear 

* AV 

egen miss = anycount (V114 V115 V116 V117 V118 V119), values(8,9)

recode V114-V119 (8=.) (9=.) 
recode V114 (4=1) (3=2) (2=3) (1=4), gen(V114_uk)
recode V118 (4=1) (3=2) (2=3) (1=4), gen(V118_uk)

factor V114-V119, mineigen(1) pcf
rotate, normalize // 1 Faktor, 52,5%

alpha V114_uk V115 V116 V117 V118_uk V119, item // Alpha = .82
alpha V115 V117 V119, item // Alpha = .78
alpha V114_uk V116 V118_uk, item // Alpha = .70

egen trad = rowmean (V114_uk V115 V116 V117 V118_uk V119) if miss < 3
replace trad = 5-trad
egen sexism = rowmean (V115 V117 V119) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (V114_uk V116 V118_uk) if miss < 3
replace fwork = 5-fwork


* UV 

recode V3 (1=1) (2=0), gen(west)

recode V4 (3=1) (1/2=0) (4=0) (9=.), gen(foreign)

recode V151 (1=1) (2=0), gen(mann) 

recode V154 (999=.)
gen age = V154

gen gebjahr = 2008 - age
 
recode V524 (9=.) (7=.)
recode V524 (1/2=1) (3/6=0), gen(evang) 
recode V524 (3=1) (1/2=0) (4/6=0), gen(kathol) 
recode V524 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode V524 (6=1) (1/5=0), gen(klos)

recode V526 (9=.) 
gen kgang = 7-V526


gen yeduc = 9 if V173 == 1 | V173 == 2
replace yeduc = 10 if V173 == 3 
replace yeduc = 12 if V173 == 4 
replace yeduc = 13 if V173 == 5
replace yeduc = 12 if V173 == 7 | V173 == 6 
egen ausbild = anycount(V174 V175 V176 V177 V179 V180 V181), values(1)
replace yeduc = yeduc + 2 if V178 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 3 if V184 == 1
replace yeduc = yeduc + 4 if V182 == 1
replace yeduc = yeduc + 5 if V183 == 1
replace yeduc = . if V173 == 9 | V174 == 9
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 13.27

gen yeduc_ep = 9 if V253 == 1 | V253 == 2
replace yeduc_ep = 10 if V253 == 3 
replace yeduc_ep = 12 if V253 == 4 
replace yeduc_ep = 13 if V253 == 5
replace yeduc_ep = 12 if V253 == 6 | V253 == 7
egen ausbild_ep = anycount(V254 V255 V256 V257 V259 V260 V261), values(1)
replace yeduc_ep = yeduc_ep + 2 if V258 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 3 if V264 == 1
replace yeduc_ep = yeduc_ep + 4 if V262 == 1
replace yeduc_ep = yeduc_ep + 5 if V263 == 1
replace yeduc_ep = . if V253 == 9 | V254 == 9
replace yeduc_ep = 13.27 if V253 == 0
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if V296 == 1 | V296 == 2
replace yeduc_p = 10 if V296 == 3
replace yeduc_p = 12 if V296 == 4
replace yeduc_p = 13 if V296 == 5
replace yeduc_p = 12 if V296 == 6 | V296 == 7
egen ausbild_p = anycount(V297 V298 V299 V300 V302 V303 V304), values(1)
replace yeduc_p = yeduc_p + 2 if V301 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 3 if V307 == 1
replace yeduc_p = yeduc_p + 4 if V305 == 1
replace yeduc_p = yeduc_p + 5 if V306 == 1
replace yeduc_p = 18 if yeduc_p > 18 & yeduc_p < .


recode V374 (8=.) (9=.) (0=.)
recode V374 (1=1) (2/6=0), gen(bv_kein)
recode V374 (1/5=0) (6=1), gen(bv_sonst) 
recode V374 (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode V374 (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode V374 (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode V374 (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode V375 (8=.) (9=.)
recode V375 (1=1) (2/6=0), gen(bm_kein)
recode V375 (1/5=0) (6=1), gen(bm_sonst) 
recode V375 (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode V375 (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode V375 (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode V375 (5=1) (1/4=0) (6=0), gen(bm_abitur)


recode V399 (996=.) (999=.)
recode V406 (996=.) (999=.)
recode V413 (996=.) (999=.)
recode V420 (996=.) (999=.)
recode V427 (996=.) (999=.)
recode V434 (996=.) (999=.)
recode V441 (996=.) (999=.)

gen k02_1 = 1 if (V395 == 3 | V395 == 4) & V399 < 3
gen k02_2 = 1 if (V402 == 3 | V402 == 4) & V406 < 3
gen k02_3 = 1 if (V409 == 3 | V409 == 4) & V413 < 3
gen k02_4 = 1 if (V416 == 3 | V416 == 4) & V420 < 3
gen k02_5 = 1 if (V423 == 3 | V423 == 4) & V427 < 3
gen k02_6 = 1 if (V430 == 3 | V430 == 4) & V434 < 3
gen k02_7 = 1 if (V437 == 3 | V437 == 4) & V441 < 3

gen k36_1 = 1 if (V395 == 3 | V395 == 4) & V399 > 2 & V399 < 7
gen k36_2 = 1 if (V402 == 3 | V402 == 4) & V406 > 2 & V406 < 7
gen k36_3 = 1 if (V409 == 3 | V409 == 4) & V413 > 3 & V413 < 7
gen k36_4 = 1 if (V416 == 3 | V416 == 4) & V420 > 2 & V420 < 7
gen k36_5 = 1 if (V423 == 3 | V423 == 4) & V427 > 2 & V427 < 7
gen k36_6 = 1 if (V430 == 3 | V430 == 4) & V434 > 2 & V434 < 7
gen k36_7 = 1 if (V437 == 3 | V437 == 4) & V441 > 2 & V441 < 7

gen k718_1 = 1 if (V395 == 3 | V395 == 4) & V399 > 6 & V399 < 19
gen k718_2 = 1 if (V402 == 3 | V402 == 4) & V406 > 6 & V406 < 19
gen k718_3 = 1 if (V409 == 3 | V409 == 4) & V413 > 6 & V413 < 19
gen k718_4 = 1 if (V416 == 3 | V416 == 4) & V420 > 6 & V420 < 19
gen k718_5 = 1 if (V423 == 3 | V423 == 4) & V427 > 6 & V427 < 19
gen k718_6 = 1 if (V430 == 3 | V430 == 4) & V434 > 6 & V434 < 19
gen k718_7 = 1 if (V437 == 3 | V437 == 4) & V441 > 6 & V441 < 19

gen kü18_1 = 1 if (V395 == 3 | V395 == 4) & V399 > 18 & V399 < .
gen kü18_2 = 1 if (V402 == 3 | V402 == 4) & V406 > 18 & V406 < .
gen kü18_3 = 1 if (V409 == 3 | V409 == 4) & V413 > 18 & V413 < .
gen kü18_4 = 1 if (V416 == 3 | V416 == 4) & V420 > 18 & V420 < .
gen kü18_5 = 1 if (V423 == 3 | V423 == 4) & V427 > 18 & V427 < .
gen kü18_6 = 1 if (V430 == 3 | V430 == 4) & V434 > 18 & V434 < .
gen kü18_7 = 1 if (V437 == 3 | V437 == 4) & V441 > 18 & V441 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & V248 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & V248 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & V248 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & V248 > 1


gen vz = 0 
replace vz = 1 if V186 == 1

gen tz = 0 
replace tz = 1 if V186 == 2

gen al = 0 
replace al = 1 if V219 == 3

gen nebenh = 0
replace nebenh = 1 if V186 == 3

gen ausb = 0 
replace ausb = 1 if V219 == 1 | V219 == 5

gen newp = 0 
replace newp = 1 if V219 == 2 | V219 == 4 | V219 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if V266 == 1

gen tz_ep = 0 
replace tz_ep = 1 if V266 == 2  

gen al_ep = 0 
replace al_ep = 1 if V289 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if V266 == 3 

gen ausb_ep = 0 
replace ausb_ep = 1 if V289 == 1 | V289 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if V289 == 2 | V289 == 4 | V289 == 6

gen ep_miss = 0 
replace ep_miss = 1 if V266 == 0


gen vz_p = vz_ep
replace vz_p = 1 if V309 == 1

gen tz_p = tz_ep
replace tz_p = 1 if V309 == 2

gen al_p = al_ep 
replace al_p = 1 if V332 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if V309 == 3 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if V332 == 1 | V332 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if V332 == 2 | V332 == 4 | V332 == 6

gen p_miss = 1 
replace p_miss = 0 if (V266 > 0 & V266 < 9) | (V309 > 0 & V309 < 9) 


recode V188 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0) (99=.), gen(autonom)

replace autonom = 0 if V188 == 0 & V223 == 0 

recode V223 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (15=3) (21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = V223 if autonom == 0


recode V7 (8=.) (9=.)
gen w_lage = V7


recode V448 (99997=.) (99998=.) (99999=.) (0=.) (.f=.) (.d=.) (.k=.)
rename V448 hhinc

 
recode V393 (99=.) 
gen hhgr = V393

gen year = 2008

gen pop_nd = 1

* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc ///
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd 

save "c:\Daten\sex_role_2008.dta", replace


************
*** 2012 ***
************

use "c:\Daten\ZA4614_v1-1-1.dta", clear 

* AV 

keep if v102 > 0

egen miss = anycount (v102 v103 v104 v105 v106 v107), values(8,9)

recode v102-v107 (0=.) (8=.) (9=.) 
recode v102 (4=1) (3=2) (2=3) (1=4), gen(v102_uk)
recode v106 (4=1) (3=2) (2=3) (1=4), gen(v106_uk)

factor v102-v107, mineigen(1) pcf
rotate, normalize // 1 Faktor, 47,2%

alpha v102_uk v103 v104 v105 v106_uk v107, item // Alpha = .78
alpha v103 v105 v107, item // Alpha = .74
alpha v102_uk v104 v106_uk, item // Alpha = .64

egen trad = rowmean (v102_uk v103 v104 v105 v106_uk v107) if miss < 3
replace trad = 5-trad
egen sexism = rowmean (v103 v105 v107) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (v102_uk v104 v106_uk) if miss < 3
replace fwork = 5-fwork


* UV 

recode v8 (1=1) (2=0), gen(west)

recode v6 (3=1) (1/2=0) (4=0) (9=.), gen(foreign)

recode v217 (1=1) (2=0), gen(mann) 

recode v220 (999=.)
gen age = v220

gen gebjahr = 2012 - age
 
recode v188 (9=.) (7=.)
recode v188 (1/2=1) (3/6=0), gen(evang) 
recode v188 (3=1) (1/2=0) (4/6=0), gen(kathol) 
recode v188 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode v188 (6=1) (1/5=0), gen(klos)

recode v269 (9=.) (0=.)
gen kgang = 7-v269


gen yeduc = 9 if v230 == 1 | v230 == 2
replace yeduc = 10 if v230 == 3 
replace yeduc = 12 if v230 == 4 
replace yeduc = 13 if v230 == 5
replace yeduc = 12 if v230 == 7 | v230 == 6 
egen ausbild = anycount(v231 v232 v233 v234 v236 v237 v238), values(1)
replace yeduc = yeduc + 2 if v235 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 3 if v241 == 1
replace yeduc = yeduc + 4 if v239 == 1
replace yeduc = yeduc + 5 if v240 == 1
replace yeduc = . if v230 == 9 | v231 == 9
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 13.54

gen yeduc_ep = 9 if v281 == 1 | v281 == 2
replace yeduc_ep = 10 if v281 == 3 
replace yeduc_ep = 12 if v281 == 4 
replace yeduc_ep = 13 if v281 == 5
replace yeduc_ep = 12 if v281 == 6 | v281 == 7
egen ausbild_ep = anycount(v282 v283 v284 v285 v287 v288 v289), values(1)
replace yeduc_ep = yeduc_ep + 2 if v286 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 3 if v292 == 1
replace yeduc_ep = yeduc_ep + 4 if v290 == 1
replace yeduc_ep = yeduc_ep + 5 if v291 == 1
replace yeduc_ep = . if v281 == 9 | v282 == 9
replace yeduc_ep = 13.54 if v281 == 0
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if v308 == 1 | v308 == 2
replace yeduc_p = 10 if v308 == 3
replace yeduc_p = 12 if v308 == 4
replace yeduc_p = 13 if v308 == 5
replace yeduc_p = 12 if v308 == 6 | v342 == 7
egen ausbild_p = anycount(v309 v310 v311 v312 v314 v315 v316), values(1)
replace yeduc_p = yeduc_p + 2 if v313 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 3 if v319 == 1
replace yeduc_p = yeduc_p + 4 if v317 == 1
replace yeduc_p = yeduc_p + 5 if v318 == 1
replace yeduc_p = 18 if yeduc_p > 18 & yeduc_p < .

recode v332 (8=.) (9=.) (99=.) (0=.)
recode v332 (1=1) (2/6=0), gen(bv_kein)
recode v332 (1/5=0) (6=1), gen(bv_sonst) 
recode v332 (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode v332 (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode v332 (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode v332 (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode v333 (8=.) (9=.) (99=.) (0=.)
recode v333 (1=1) (2/6=0), gen(bm_kein)
recode v333 (1/5=0) (6=1), gen(bm_sonst) 
recode v333 (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode v333 (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode v333 (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode v333 (5=1) (1/4=0) (6=0), gen(bm_abitur)


recode v357 (996=.) (999=.)
recode v367 (996=.) (999=.)
recode v377 (996=.) (999=.)
recode v387 (996=.) (999=.)
recode v397 (996=.) (999=.)
recode v407 (996=.) (999=.)
recode v417 (996=.) (999=.)

gen k02_1 = 1 if (v353 == 3 | v353 == 4) & v357 < 3
gen k02_2 = 1 if (v363 == 3 | v363 == 4) & v367 < 3
gen k02_3 = 1 if (v373 == 3 | v373 == 4) & v377 < 3
gen k02_4 = 1 if (v383 == 3 | v383 == 4) & v387 < 3
gen k02_5 = 1 if (v393 == 3 | v393 == 4) & v397 < 3
gen k02_6 = 1 if (v403 == 3 | v403 == 4) & v407 < 3
gen k02_7 = 1 if (v413 == 3 | v413 == 4) & v417 < 3

gen k36_1 = 1 if (v353 == 3 | v353 == 4) & v357 > 2 & v357 < 7
gen k36_2 = 1 if (v363 == 3 | v363 == 4) & v367 > 2 & v367 < 7
gen k36_3 = 1 if (v373 == 3 | v373 == 4) & v377 > 3 & v377 < 7
gen k36_4 = 1 if (v383 == 3 | v383 == 4) & v387 > 2 & v387 < 7
gen k36_5 = 1 if (v393 == 3 | v393 == 4) & v397 > 2 & v397 < 7
gen k36_6 = 1 if (v403 == 3 | v403 == 4) & v407 > 2 & v407 < 7
gen k36_7 = 1 if (v413 == 3 | v413 == 4) & v417 > 2 & v417 < 7

gen k718_1 = 1 if (v353 == 3 | v353 == 4) & v357 > 6 & v357 < 19
gen k718_2 = 1 if (v363 == 3 | v363 == 4) & v367 > 6 & v367 < 19
gen k718_3 = 1 if (v373 == 3 | v373 == 4) & v377 > 6 & v377 < 19
gen k718_4 = 1 if (v383 == 3 | v383 == 4) & v387 > 6 & v387 < 19
gen k718_5 = 1 if (v393 == 3 | v393 == 4) & v397 > 6 & v397 < 19
gen k718_6 = 1 if (v403 == 3 | v403 == 4) & v407 > 6 & v407 < 19
gen k718_7 = 1 if (v413 == 3 | v413 == 4) & v417 > 6 & v417 < 19

gen kü18_1 = 1 if (v353 == 3 | v353 == 4) & v357 > 18 & v357 < .
gen kü18_2 = 1 if (v363 == 3 | v363 == 4) & v367 > 18 & v367 < .
gen kü18_3 = 1 if (v373 == 3 | v373 == 4) & v377 > 18 & v377 < .
gen kü18_4 = 1 if (v383 == 3 | v383 == 4) & v387 > 18 & v387 < .
gen kü18_5 = 1 if (v393 == 3 | v393 == 4) & v397 > 18 & v397 < .
gen kü18_6 = 1 if (v403 == 3 | v403 == 4) & v407 > 18 & v407 < .
gen kü18_7 = 1 if (v413 == 3 | v413 == 4) & v417 > 18 & v417 < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0

gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & v274 == 1

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & v274 == 1 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & v274 > 1

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & v274 > 1


gen vz = 0 
replace vz = 1 if v245 == 1

gen tz = 0 
replace tz = 1 if v245 == 2

gen al = 0 
replace al = 1 if v259 == 3

gen nebenh = 0
replace nebenh = 1 if v245 == 3

gen ausb = 0 
replace ausb = 1 if v259 == 1 | v259 == 5

gen newp = 0 
replace newp = 1 if v259 == 2 | v259 == 4 | v259 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if v296 == 1

gen tz_ep = 0 
replace tz_ep = 1 if v296 == 2  

gen al_ep = 0 
replace al_ep = 1 if v299 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if v296 == 3 

gen ausb_ep = 0 
replace ausb_ep = 1 if v299 == 1 | v299 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if v299 == 2 | v299 == 4 | v299 == 6

gen ep_miss = 0 
replace ep_miss = 1 if v296 == 0


gen vz_p = vz_ep
replace vz_p = 1 if v323 == 1

gen tz_p = tz_ep
replace tz_p = 1 if v323 == 2

gen al_p = al_ep 
replace al_p = 1 if v326 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if v323 == 3 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if v326 == 1 | v326 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if v326 == 2 | v326 == 4 | v326 == 6

gen p_miss = 1 
replace p_miss = 0 if (v296 > 0 & v296 < 9) | (v323 > 0 & v323 < 9) 


recode v247 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (14/15=3) (20/21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=0) (99=.), gen(autonom)

replace autonom = 0 if v247 == 0 & v263 == 0 

recode v263 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (14/15=3) (20/21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (99=.) 

replace autonom = v263 if autonom == 0


recode v119 (8=.) (9=.)
gen w_lage = v119


recode v427 (99997=.) (99998=.) (99999=.) (0=.) (.f=.) (.d=.) (.k=.)
rename v427 hhinc


recode v351 (99=.) 
gen hhgr = v351

gen year = 2012

gen pop_nd = 1

* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc ///
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd 

save "c:\Daten\sex_role_2012.dta", replace


************
*** 2016 ***
************

use "c:\Daten\ZA5250_v2-0-0.dta", clear 


* AV 

keep if splt16_1 == 1 

recode fr01 fr02 fr03 fr04 fr05 fr06 (-8=.) (-9=.) 

egen miss = rowmiss(fr01-fr06)

recode fr01 (4=1) (3=2) (2=3) (1=4), gen(fr01_uk)
recode fr05 (4=1) (3=2) (2=3) (1=4), gen(fr05_uk)

factor fr01-fr06, mineigen(1) pcf
rotate, normalize // 2 Faktoren, 62,5%

alpha fr02 fr04 fr06, item // Alpha = .70
alpha fr01_uk fr03 fr05_uk, item // Alpha = .65

egen sexism = rowmean (fr02 fr04 fr06) if miss < 3 
replace sexism = 5-sexism
egen fwork = rowmean (fr01_uk fr03 fr05_uk) if miss < 3
replace fwork = 5-fwork
egen trad = rowmean (fr02 fr04 fr06 fr01_uk fr03 fr05_uk) if miss < 3
replace trad = 5-trad

corr sexism fwork trad

* UV 

recode eastwest (1=1) (2=0), gen(west)

recode german (3=1) (1/2=0), gen(foreign)
recode foreign (-32=.) (.f=.) (.d=.) (.k=.) 

recode sex (1=1) (2=0), gen(mann)

recode age (-32=.) (.k=.)

gen gebjahr = 2016 - age

recode rd01 (-7=.) (-9=.) (.f=.) (.d=.) (.k=.)
recode rd01 (1/2=1) (3/6=0), gen(evang) 
recode rd01 (3=1) (1/2=0) (4/6=0), gen(kathol) 
recode rd01 (4/5=1) (1/3=0) (6=0), gen(sonst) 
recode rd01 (6=1) (1/5=0), gen(klos)

recode rp01 (-9=.) (-10=.)
gen kgang = 7-rp01

recode educ (-41=.) (-9=.) (.f=.) (.d=.) (.k=.)
gen yeduc = 9 if educ == 1 | educ == 2
replace yeduc = 10 if educ == 3 
replace yeduc = 12 if educ == 4 
replace yeduc = 13 if educ == 5
replace yeduc = 12 if educ == 7 | educ == 6 
egen ausbild = anycount(de06 de07 de08 de09 de11 de12 de13 de16), values(1)
replace yeduc = yeduc + 2 if de10 == 1
replace yeduc = yeduc + 3 if ausbild > 0
replace yeduc = yeduc + 4 if de14 == 1
replace yeduc = yeduc + 5 if de15 == 1
replace yeduc = 18 if yeduc > 18 & yeduc < .

sum yeduc // 13.97

gen yeduc_ep = 9 if sceduc == 1 | sceduc == 2
replace yeduc_ep = 10 if sceduc == 3 
replace yeduc_ep = 12 if sceduc == 4 
replace yeduc_ep = 13 if sceduc == 5
replace yeduc_ep = 12 if sceduc == 6 | sceduc == 7
egen ausbild_ep = anycount(scde06 scde07 scde08 scde09 scde12 scde11 scde13 scde16), values(1)
replace yeduc_ep = yeduc_ep + 2 if scde10 == 1
replace yeduc_ep = yeduc_ep + 3 if ausbild_ep > 0
replace yeduc_ep = yeduc_ep + 4 if scde14 == 1
replace yeduc_ep = yeduc_ep + 5 if scde15 == 1
replace yeduc_ep = 18 if yeduc_ep > 18 & yeduc_ep < .
replace yeduc_ep = 13.97 if yeduc_ep == .

gen yeduc_p = yeduc_ep
replace yeduc_p = 9 if peduc == 1 | peduc == 2
replace yeduc_p = 10 if peduc == 3
replace yeduc_p = 12 if peduc == 4
replace yeduc_p = 13 if peduc == 5
replace yeduc_p = 12 if peduc == 6 | peduc == 7
egen ausbild_p = anycount(pde06 pde07 pde08 pde09 pde12 pde11 pde13 pde16), values(1)
replace yeduc_p = yeduc_p + 2 if pde10 == 1
replace yeduc_p = yeduc_p + 3 if ausbild_p > 0
replace yeduc_p = yeduc_p + 4 if pde14 == 1
replace yeduc_p = yeduc_p + 5 if pde15 == 1
replace yeduc_p = 18 if yeduc_p > 18 & yeduc_p < .
replace yeduc_p = 13.97 if yeduc_p == .

recode feduc (.f=.) (.d=.) (.k=.)
recode feduc (1=1) (2/6=0), gen(bv_kein)
recode feduc (1/5=0) (6=1), gen(bv_sonst) 
recode feduc (2=1) (1=0) (3/6=0), gen(bv_volks) 
recode feduc (3=1) (1/2=0) (4/6=0), gen(bv_mittlere) 
recode feduc (4=1) (1/3=0) (5/6=0), gen(bv_fachhoch) 
recode feduc (5=1) (1/4=0) (6=0), gen(bv_abitur)

recode meduc (.f=.) (.d=.) (.k=.)
recode meduc (1=1) (2/6=0), gen(bm_kein)
recode meduc (1/5=0) (6=1), gen(bm_sonst) 
recode meduc (2=1) (1=0) (3/6=0), gen(bm_volks) 
recode meduc (3=1) (1/2=0) (4/6=0), gen(bm_mittlere) 
recode meduc (4=1) (1/3=0) (5/6=0), gen(bm_fachhoch) 
recode meduc (5=1) (1/4=0) (6=0), gen(bm_abitur)

gen k02_1 = 1 if (hh2kin == 3 | hh2kin == 4) & hh2age < 3
gen k02_2 = 1 if (hh3kin == 3 | hh3kin == 4) & hh3age < 3
gen k02_3 = 1 if (hh4kin == 3 | hh4kin == 4) & hh4age < 3
gen k02_4 = 1 if (hh5kin == 3 | hh5kin == 4) & hh5age < 3
gen k02_5 = 1 if (hh6kin == 3 | hh6kin == 4) & hh6age < 3
gen k02_6 = 1 if (hh7kin == 3 | hh7kin == 4) & hh7age < 3
gen k02_7 = 1 if (hh8kin == 3 | hh8kin == 4) & hh8age < 3

gen k36_1 = 1 if (hh2kin == 3 | hh2kin == 4) & hh2age > 2 & hh2age < 7
gen k36_2 = 1 if (hh3kin == 3 | hh3kin == 4) & hh3age > 2 & hh3age < 7
gen k36_3 = 1 if (hh4kin == 3 | hh4kin == 4) & hh4age > 3 & hh4age < 7
gen k36_4 = 1 if (hh5kin == 3 | hh5kin == 4) & hh5age > 2 & hh5age < 7
gen k36_5 = 1 if (hh6kin == 3 | hh6kin == 4) & hh6age > 2 & hh6age < 7
gen k36_6 = 1 if (hh7kin == 3 | hh7kin == 4) & hh7age > 2 & hh7age < 7
gen k36_7 = 1 if (hh8kin == 3 | hh8kin == 4) & hh8age > 2 & hh8age < 7

gen k718_1 = 1 if (hh2kin == 3 | hh2kin == 4) & hh2age > 6 & hh2age < 19
gen k718_2 = 1 if (hh3kin == 3 | hh3kin == 4) & hh3age > 6 & hh3age < 19
gen k718_3 = 1 if (hh4kin == 3 | hh4kin == 4) & hh4age > 6 & hh4age < 19
gen k718_4 = 1 if (hh5kin == 3 | hh5kin == 4) & hh5age > 6 & hh5age < 19
gen k718_5 = 1 if (hh6kin == 3 | hh6kin == 4) & hh6age > 6 & hh6age < 19
gen k718_6 = 1 if (hh7kin == 3 | hh7kin == 4) & hh7age > 6 & hh7age < 19
gen k718_7 = 1 if (hh8kin == 3 | hh8kin == 4) & hh8age > 6 & hh8age < 19

gen kü18_1 = 1 if (hh2kin == 3 | hh2kin == 4) & hh2age > 18 & hh2age < .
gen kü18_2 = 1 if (hh3kin == 3 | hh3kin == 4) & hh3age > 18 & hh3age < .
gen kü18_3 = 1 if (hh4kin == 3 | hh4kin == 4) & hh4age > 18 & hh4age < .
gen kü18_4 = 1 if (hh5kin == 3 | hh5kin == 4) & hh5age > 18 & hh5age < .
gen kü18_5 = 1 if (hh6kin == 3 | hh6kin == 4) & hh6age > 18 & hh6age < .
gen kü18_6 = 1 if (hh7kin == 3 | hh7kin == 4) & hh7age > 18 & hh7age < .
gen kü18_7 = 1 if (hh8kin == 3 | hh8kin == 4) & hh8age > 18 & hh8age < .

egen n_k02 = anycount (k02_1 k02_2 k02_3 k02_4 k02_5 k02_6 k02_7), values(1) 
egen n_k36 = anycount (k36_1 k36_2 k36_3 k36_4 k36_5 k36_6 k36_7), values(1)
egen n_k718 = anycount (k718_1 k718_2 k718_3 k718_4 k718_5 k718_6 k718_7), values(1)
egen n_kü18 = anycount (kü18_1 kü18_2 kü18_3 kü18_4 kü18_5 kü18_6 kü18_7), values(1)

gen ku18 = 0 
replace ku18 = 1 if n_k02 > 0 | n_k36 > 0 | n_k718 > 0


recode mstat (-9=.) (.f=.) (.d=.) (.k=.)
gen verh_mk = 0 
replace verh_mk = 1 if ku18 == 1 & (mstat == 1 | mstat == 7)

gen verh_ok = 0 
replace verh_ok = 1 if ku18 == 0 & (mstat == 1 | mstat == 7) 

gen nverh_mk = 0 
replace nverh_mk = 1 if ku18 == 1 & mstat > 1 & mstat < 7

gen nverh_ok = 0 
replace nverh_ok = 1 if ku18 == 0 & mstat > 1 & mstat < 7


gen vz = 0 
replace vz = 1 if work == 1

gen tz = 0 
replace tz = 1 if work == 2

gen al = 0 
replace al = 1 if dw03 == 3

gen nebenh = 0
replace nebenh = 1 if work == 3

gen ausb = 0 
replace ausb = 1 if dw03 == 1 | dw03 == 5

gen newp = 0 
replace newp = 1 if dw03 == 2 | dw03 == 4 | dw03 == 6  


gen vz_ep = 0 
replace vz_ep = 1 if scwork == 1

gen tz_ep = 0 
replace tz_ep = 1 if scwork == 2  

gen al_ep = 0 
replace al_ep = 1 if scdw03 == 3

gen nebenh_ep = 0 
replace nebenh_ep = 1 if scwork == 3 

gen ausb_ep = 0 
replace ausb_ep = 1 if scdw03 == 1 | scdw03 == 5 

gen newp_ep = 0 
replace newp_ep = 1 if scdw03 == 2 | scdw03 == 4 | scdw03 == 6

gen ep_miss = 0 
replace ep_miss = 1 if mstat > 1 & mstat < 6


gen vz_p = vz_ep
replace vz_p = 1 if pwork == 1

gen tz_p = tz_ep
replace tz_p = 1 if pwork == 2

gen al_p = al_ep 
replace al_p = 1 if pdw03 == 3

gen nebenh_p = nebenh_ep 
replace nebenh_p = 1 if pwork == 3 

gen ausb_p = ausb_ep 
replace ausb_p = 1 if pdw03 == 1 | pdw03 == 5

gen newp_p = newp_ep
replace newp_ep = 1 if pdw03 == 2 | pdw03 == 4 | pdw03 == 6

gen p_miss = 0 
replace p_miss = 1 if dp01 == 2  


recode dw02 (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (14/15=3) (20/21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (.f=.) (.d=.) (.k=.), gen(autonom)

replace autonom = 0 if work == 4

recode dw02a (60/61=1) (40=2) (51=2) (62=2) (10/11=2) (41=3) (52=3) (63=3) ///
(12=3) (65=3) (14/15=3) (20/21=3) (30=3) (42=4) (50=4) (53=4) (64=4) (13=4) (16=4) (22=4) ///
(43=5) (54=5) (17=5) (23/24=5) (70/74=1) (49=1) (0=.) (.f=.) (.d=.) (.k=.)

replace autonom = dw02a if autonom == 0
recode autonom (-10=.) (-9=.) (.e=.)

recode ep03 (-8=.) (.f=.) (.d=.) (.k=.)
gen w_lage = ep03

recode dh04 (-8=.)
recode dh04 (.k=.)
gen hhgr = dh04

gen year = 2016

gen pop_nd = 1

recode hhinc (-9=.) (-50=.) (-32=.) (0=.) (.f=.) (.d=.) (.k=.)


* Save

keep trad sexism fwork west foreign mann age gebjahr evang kathol sonst klos kgang yeduc ///
yeduc_ep yeduc_p bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur ///
bm_kein bm_sonst bm_volks bm_mittlere bm_fachhoch bm_abitur ///
n_k02 n_k36 n_k718 n_kü18 verh_mk verh_ok nverh_mk nverh_ok vz tz al nebenh /// 
ausb newp vz_ep tz_ep al_ep nebenh_ep ausb_ep newp_ep ep_miss autonom ///
vz_p tz_p al_p nebenh_p ausb_p newp_p p_miss ///
w_lage hhinc hhgr year pop_nd 

save "c:\Daten\sex_role_2016.dta", replace


**************
*** Append ***
**************

use "c:\Daten\sex_role_1982.dta", clear 

append using "c:\Daten\sex_role_1991.dta"
append using "c:\Daten\sex_role_1992.dta"
append using "c:\Daten\sex_role_1996.dta"
append using "c:\Daten\sex_role_2000.dta"
append using "c:\Daten\sex_role_2004.dta"
append using "c:\Daten\sex_role_2008.dta"
append using "c:\Daten\sex_role_2012.dta"
append using "c:\Daten\sex_role_2016.dta"

save "c:\Daten\sex_role_combined.dta", replace


******************************
*** Income Transformations ***
******************************

gen hhgr_sqrt = sqrt(hhgr)

replace hhinc = hhinc / hhgr_sqrt 

* Note: Source of price indices: "Statistisches Bundesamt (2016): Verbraucherpreisindizes für Deutschland", 
* lange Reihe an 1948", 13.05.2016, westdeutsche Preise 1982

replace hhinc = hhinc * 0.570 if year == 2016 & west == 1
replace hhinc = hhinc * 0.591 if year == 2012 & west == 1
replace hhinc = hhinc * 0.618 if year == 2008 & west == 1
replace hhinc = hhinc * 0.662 if year == 2004 & west == 1 
replace hhinc = hhinc * 0.699 if year == 2000 & west == 1
replace hhinc = hhinc * 0.733 if year == 1996 & west == 1
replace hhinc = hhinc * 0.803 if year == 1992 & west == 1
replace hhinc = hhinc * 0.835 if year == 1991 & west == 1

replace hhinc = hhinc * 0.581 if year == 2016 & west == 0
replace hhinc = hhinc * 0.596 if year == 2012 & west == 0
replace hhinc = hhinc * 0.623 if year == 2008 & west == 0
replace hhinc = hhinc * 0.666 if year == 2004 & west == 0 
replace hhinc = hhinc * 0.705 if year == 2000 & west == 0
replace hhinc = hhinc * 0.741 if year == 1996 & west == 0
replace hhinc = hhinc * 0.882 if year == 1992 & west == 0


********************************************
*** Cohort Grouping, APC transformations ***
********************************************

* Cohort

recode hhgr (-32=.)

recode gebjahr (1892/1905.49=1) (1905.5/1910.49=2) (1910.5/1915.49=3) (1915.5/1920.49=4) (1920.5/1925.49=5) (1925.5/1930.49=6) ///
(1930.5/1935.499=7) (1935.5/1940.49=8) (1940.5/1945.49=9) (1945.5/1950.49=10) (1950.5/1955.49=11) (1955.5/1960.49=12) (1960.5/1965.49=13) ///
(1965.5/1970.49=14) (1970.5/1975.49=15) (1975.5/1980.49=16) (1980.5/1985.49=17) (1985.5/2000=18), gen(kohorte)

tab kohorte, gen(k) 

recode gebjahr (1892/1921 = 1) (1922/1934 = 2) (1935/1945 = 3) (1946/1953 = 4) (1954/1964 = 5) (1965/1975 = 6) ///
(1976/1998 = 7) if west == 1, gen(koh_west)

tab koh_west, gen(kw)

recode gebjahr (1892/1930 = 1) (1931/1945 = 2) (1946/1960 = 3) (1961/1974 = 4) (1975/1998 = 5) if west == 0, gen(koh_ost)

tab koh_ost, gen(ko)

* Age, Period, Cohort  

tab year, gen(y)

sum age, detail

recode age (17/28=1) (29/46=2) (47/61=3) (62/97=4), gen(age_kat) 
tab age_kat, gen(ag)

gen ageq = age * age
replace ageq = ageq / 100

recode year (1982=0) (1991=9) (1992=10) (1996=14) (2000=18) (2004=22) (2008=26) (2012=30) (2016=34)

sum gebjahr
replace gebjahr = gebjahr - 1951
gen gbq = gebjahr * gebjahr
replace gebjahr = gebjahr / 100
replace gbq = gbq / 100

* Other 

gen vz_po = vz_ep 
replace vz_po = 1 if vz_p == 1 
gen tz_po = tz_ep 
replace tz_po = 1 if tz_p == 1
gen al_po = al_ep 
replace al_po = 1 if al_p == 1
gen nebenh_po = nebenh_ep
replace nebenh_po = 1 if nebenh_p == 1
gen ausb_po = ausb_ep
replace ausb_po = 1 if ausb_p == 1
gen newp_po = newp_ep
replace newp_po = 1 if newp_p == 1

recode bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur (-8=.) (-9=.) (-10=.) (.e=.)
recode evang kathol sonst klos (.c=.) (.e=.)

replace hhinc = hhinc / 100

save "c:\Daten\sex_role_combined.dta", replace


*******************************
*** Group-Specific Datasets ***
*******************************

keep if west == 1 & mann == 0

save "c:\Daten\sex_role_combined_wf.dta", replace

use "c:\Daten\sex_role_combined.dta", clear 

keep if west == 1 & mann == 1 

save "c:\Daten\sex_role_combined_wm.dta", replace

use "c:\Daten\sex_role_combined.dta", clear 

keep if west == 0 & mann == 0 

save "c:\Daten\sex_role_combined_of.dta", replace

use "c:\Daten\sex_role_combined.dta", clear 

keep if west == 0 & mann == 1

save "c:\Daten\sex_role_combined_om.dta", replace


*************************
*** MPLUS Preparation ***
*************************

* West German Woman 

use "c:\Daten\sex_role_combined_wf.dta", clear

drop if fwork == .
drop if sexism == .

keep sexism fwork hhgr foreign y1-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

order sexism fwork hhgr foreign y1-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

recode _all (. = -99) 

outfile _all using "c:\Daten\westfrau.dat", nolabel noquote replace 


* East German Women 

use "c:\Daten\sex_role_combined_of.dta", clear

drop if fwork == .
drop if sexism == .

keep sexism fwork hhgr foreign y2-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

order sexism fwork hhgr foreign y2-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

recode _all (. = -99) 

outfile _all using "c:\Daten\ostfrau.dat", nolabel noquote replace 


* West German Men 

use "c:\Daten\sex_role_combined_wm.dta", clear

drop if fwork == .
drop if sexism == .

keep sexism fwork hhgr foreign y1-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

order sexism fwork hhgr foreign y1-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

recode _all (. = -99) 

outfile _all using "c:\Daten\westmann.dat", nolabel noquote replace 


* East German Men 

use "c:\Daten\sex_role_combined_om.dta", clear

drop if fwork == .
drop if sexism == .

keep sexism fwork hhgr foreign y2-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

order sexism fwork hhgr foreign y2-y9 year k1-k18 gebjahr gbq ausb vz tz n_k02 n_k36 n_k718 ///
ag1-ag4 age ageq verh_mk verh_ok nverh_ok nverh_mk vz_po tz_ep ausb_po ep_miss kgang evang kathol sonst klos ///
yeduc yeduc_ep bv_kein bv_sonst bv_volks bv_mittlere bv_fachhoch bv_abitur autonom w_lage hhinc

recode _all (. = -99) 

outfile _all using "c:\Daten\ostmann.dat", nolabel noquote replace 


********************************************
*** Data Analysis: see Mplus input files ***
********************************************
